/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.gunner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.SingleJsonFileReloadListener;
import dev.toma.gunsrpg.resource.adapter.GunnerGlobalPropertyAdapter;
import dev.toma.gunsrpg.resource.adapter.GunnerLoadoutsAdapter;
import dev.toma.gunsrpg.resource.gunner.GunnerGlobalProperties;
import dev.toma.gunsrpg.resource.gunner.GunnerLoadoutInstance;
import dev.toma.gunsrpg.resource.gunner.GunnerLoadouts;
import dev.toma.gunsrpg.util.math.WeightedRandom;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ZombieGunnerWeaponManager
extends SingleJsonFileReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(GunnerLoadouts.class, (Object)new GunnerLoadoutsAdapter()).registerTypeAdapter(GunnerGlobalProperties.class, (Object)new GunnerGlobalPropertyAdapter()).create();
    private static final Marker MARKER = MarkerManager.getMarker((String)"ZombieGunnerLoadouts");
    private WeightedRandom<GunnerLoadoutInstance> randomGear;

    public ZombieGunnerWeaponManager() {
        super(GunsRPG.makeResource("loadout/gunner_settings.json"), GSON);
    }

    public GunnerLoadoutInstance getLoadout() {
        return this.randomGear != null ? this.randomGear.getRandom() : null;
    }

    protected void apply(JsonElement data, IResourceManager manager, IProfiler profiler) {
        try {
            GunsRPG.log.info(MARKER, "Loading zombie gunner loadouts");
            if (!data.isJsonObject()) {
                throw new JsonSyntaxException("Data must be in object structure!");
            }
            JsonObject object = data.getAsJsonObject();
            GunnerLoadouts loadouts = (GunnerLoadouts)GSON.fromJson((JsonElement)object, GunnerLoadouts.class);
            GunnerLoadoutInstance[] instances = loadouts.getLoadouts();
            this.randomGear = new WeightedRandom<GunnerLoadoutInstance>(GunnerLoadoutInstance::getWeight, instances);
            GunsRPG.log.info(MARKER, "Zombie gunner loadouts loaded, total {} entries", (Object)instances.length);
        }
        catch (JsonParseException jpe) {
            GunsRPG.log.error(MARKER, "Error loading zombie gunner loadouts, ", (Throwable)jpe);
        }
    }
}

